

if GAMESTATE:IsEventMode() and GAMESTATE:IsPlayerEnabled(0) and GAMESTATE:IsPlayerEnabled(1) then
	local d1 = GAMESTATE:GetCurrentSteps(0):GetDifficulty()
	local d2 = GAMESTATE:GetCurrentSteps(1):GetDifficulty()

	local sTable = GAMESTATE:GetCurrentSong():GetStepsByStepsType( "StepsType_Dance_Single" );

	if d1 == 'Difficulty_Challenge' and d2 == 'Difficulty_Challenge' then
		return Def.ActorFrame {
			OnCommand=function(self)
				local r = math.random(1,2)
				GAMESTATE:SetCurrentSteps(0,sTable[r])
				GAMESTATE:SetCurrentSteps(1,sTable[3-r])
				SCREENMAN:SetNewScreen('ScreenGameplay')
			end
		}
	end
end

local global_actors = {
	answers={},
	piano_sounds={},
}
local player_actors = {{},{}}


local ANSWER_SPACING = 75
local ARROW_X = _screen.cx - 100
local ANSWER_X = ARROW_X + 140
local ANSWER_Y = 155
local ARROW_SCALE = 1.0
local QUESTION_Y = 60
local ANSWER_SCALE = 1.5
local TIMER_Y = 15

local on_command
local input_handler
local piano_timer_listener
local wrong_timer_listener
local right_timer_listener
local timeout_listener

local seconds_remaining = 75

local actor_frame = Def.ActorFrame {
	InitCommand=function(self)
		global_actors.container = self
	end,
	OnCommand=function(self)
		on_command()
		self:sleep(9999)
		SCREENMAN:GetTopScreen():AddInputCallback(input_handler)
	end,
	Def.Quad {
		InitCommand=function(self)
			self:xy(_screen.cx, _screen.cy)
			self:setsize(_screen.w, _screen.h)
			self:diffuse(0,0,0,1)
		end,
	},
	Def.ActorFrame {
		InitCommand=function(self)
			global_actors.question_container = self
		end,
		Def.Sprite {
			Texture = "../img/receptor 4x1.png",
			InitCommand = function(self)
				self:xy(ARROW_X, ANSWER_Y)
				self:rotationz(90)
				self:zoom(ARROW_SCALE)
			end,
		},
		Def.Sprite {
			Texture = "../img/receptor 4x1.png",
			InitCommand = function(self)
				self:xy(ARROW_X, ANSWER_Y + ANSWER_SPACING)
				self:zoom(ARROW_SCALE)
			end,
		},
		Def.Sprite {
			Texture = "../img/receptor 4x1.png",
			InitCommand = function(self)
				self:xy(ARROW_X, ANSWER_Y + 2*ANSWER_SPACING)
				self:rotationz(180)
				self:zoom(ARROW_SCALE)
			end,
		},
		Def.Sprite {
			Texture = "../img/receptor 4x1.png",
			InitCommand = function(self)
				self:xy(ARROW_X, ANSWER_Y + 3*ANSWER_SPACING)
				self:rotationz(270)
				self:zoom(ARROW_SCALE)
			end,
		},
		Def.BitmapText {
			Font="Common normal",
			InitCommand=function(self)
				self:xy(ANSWER_X, ANSWER_Y)
				self:zoom(ANSWER_SCALE)
				global_actors.answers[1] = self
			end,
		},
		Def.BitmapText {
			Font="Common normal",
			InitCommand=function(self)
				self:xy(ANSWER_X, ANSWER_Y + ANSWER_SPACING)
				self:zoom(ANSWER_SCALE)
				global_actors.answers[2] = self
			end,
		},
		Def.BitmapText {
			Font="Common normal",
			InitCommand=function(self)
				self:xy(ANSWER_X, ANSWER_Y + 2*ANSWER_SPACING)
				self:zoom(ANSWER_SCALE)
				global_actors.answers[3] = self
			end,
		},
		Def.BitmapText {
			Font="Common normal",
			InitCommand=function(self)
				self:xy(ANSWER_X, ANSWER_Y + 3*ANSWER_SPACING)
				self:zoom(ANSWER_SCALE)
				global_actors.answers[4] = self
			end,
		},
		Def.BitmapText {
			Font="Common normal",
			InitCommand=function(self)
				self:xy(_screen.cx, QUESTION_Y)
				self:zoom(2)
				global_actors.question = self
			end
		},
	},
	Def.ActorFrame {
		InitCommand=function(self)
			global_actors.piano_timer = self
		end,
		TriggerCommand=function(self)
			piano_timer_listener()
		end,
	},
	Def.BitmapText {
		Font="Common normal",
		InitCommand=function(self)
			self:xy(_screen.cx, TIMER_Y)
		end,
		OnCommand=function(self)
			self:queuecommand('Tick')
		end,
		TickCommand=function(self)
			self:settext(tostring(seconds_remaining))
			
			if seconds_remaining == 0 then
				timeout_listener()
			else
				seconds_remaining = seconds_remaining - 1
				self:sleep(1)
				self:queuecommand('Tick')
			end
		end,
	},
	LoadActor('../audio/wrong.ogg')..{
		SupportPan=true,
		SupportRateChanging=true,
		IsAction=false,
		
		InitCommand=function(self)
			global_actors.wrong_sound = self
		end,
		
		PlayCommand=function(self)
			self:play()
		end
	},
	LoadActor('../audio/right.ogg')..{
		SupportPan=true,
		SupportRateChanging=true,
		IsAction=false,
		
		InitCommand=function(self)
			global_actors.right_sound = self
		end,
		
		PlayCommand=function(self)
			self:play()
		end
	}
}

for i=1,26 do
	local path = '../audio/piano0.ogg'
	
	actor_frame[#actor_frame+1] = LoadActor(path)..{
		SupportPan=true,
		SupportRateChanging=true,
		IsAction=false,
		
		InitCommand=function(self)
			global_actors.piano_sounds[i] = self
			self:get():pitch(math.pow(2.0,(i-1.0)/13.0))
		end,
		
		PlayCommand=function(self)
			self:play()
		end
	}
end

for player_index=1,2 do
	local x
	if player_index == 1 then
		x = 120
	else
		x = _screen.w - 120
	end

	actor_frame[#actor_frame+1] = Def.ActorFrame {
		InitCommand=function(self)
			player_actors[player_index].right = self
			self:xy(x,_screen.cy)
			self:diffusealpha(0)
			self:rotationz(45)
		end,
		EndRightCommand=function(self)
			right_timer_listener(player_index)
		end,
		Def.Quad {
			InitCommand=function(self)
				self:setsize(30,10)
				self:diffuse(0,1,0,1)
				self:xy(-10,0)
			end,
		},
		Def.Quad {
			InitCommand=function(self)
				self:setsize(10,60)
				self:diffuse(0,1,0,1)
				self:xy(0,-25)
			end,
		},
	}
	
	actor_frame[#actor_frame+1] = Def.ActorFrame {
		InitCommand=function(self)
			player_actors[player_index].wrong = self
			self:xy(x,_screen.cy)
			self:diffusealpha(0)
		end,
		EndWrongCommand=function(self)
			wrong_timer_listener(player_index)
		end,
		Def.Quad {
			InitCommand=function(self)
				self:setsize(10,60)
				self:rotationz(-45)
				self:diffuse(1,0,0,1)
			end,
		},
		Def.Quad {
			InitCommand=function(self)
				self:setsize(10,60)
				self:rotationz(45)
				self:diffuse(1,0,0,1)
			end,
		},
	}
	
	actor_frame[#actor_frame+1] = Def.BitmapText {
		Font="Common normal",
		InitCommand=function(self)
			player_actors[player_index].score = self
			self:xy(x,_screen.cy - 100)
			self:zoom(2)
			self:settext('SCORE: 0')
		end,
	}
end

local INTERVALS = {
	{
		name = 'v smolboye',
		notes = {0,1},
	},
	{
		name = 'p smolboye',
		notes = {0,2},
	},
	{
		name = 'sadboye',
		notes = {0,3},
	},
	{
		name = 'gladboye',
		notes = {0,4},
	},
	{
		name = 'HECK',
		notes = {0,5},
	},
	{
		name = 'narrowboye',
		notes = {0,6},
	},
	{
		name = 'W I D E B O Y E',
		notes = {0,7},
	},
	{
		name = 'growlboye',
		notes = {0,8},
	},
	{
		name = 'inverted gladboye',
		notes = {0,9},
	},
	{
		name = 'inverted sadboye',
		notes = {0,10},
	},
	{
		name = 'lesser BIGBOYE',
		notes = {0,11},
	},
	{
		name = 'greater BIGBOYE',
		notes = {0,12},
	},
}

local TRIADS = {
	{
		name = 'Oof',
		notes = {0,3,6},
	},
	{
		name = 'Narrow Sad',
		notes = {0,3,7},
	},
	{
		name = 'Wide Sad',
		notes = {0,3,8},
	},
	{
		name = 'Narrow Happy',
		notes = {0,4,7},
	},
	{
		name = 'Wide Happy',
		notes = {0,4,8},
	},
}

local SCALES = {
	{
		name = 'Maxer',
		notes = {0,2,4,6,8,10,12,13},
	},
	{
		name = 'Mixer',
		notes = {0,2,4,6,8,10,11,13},
	},
	{
		name = 'Majmin',
		notes = {0,2,4,6,8,9,11,13},
	},
	{
		name = 'Narwid',
		notes = {0,2,4,6,7,9,11,13},
	},
	{
		name = 'Smush+',
		notes = {0,2,4,5,7,9,11,13},
	},
	{
		name = 'Smush-',
		notes = {0,2,3,5,7,9,11,13},
	},
	{
		name = 'Phrongian',
		notes = {0,1,3,5,7,9,11,13},
	},
}

local NOTE_QUESTION_DATA = {
	{
		description = 'Boye',
		pitch_sets = INTERVALS,
		note_separation = 0,
	},
	{
		description = 'Jamboree',
		pitch_sets = TRIADS,
		note_separation = 0.05,
	},
	{
		description = 'Jawn',
		pitch_sets = SCALES,
		note_separation = 0.4,
	},
}

local quiz_state = {
	question_index = 0,
	scores = {0,0},
	is_wrong = {false,false},
}

local piano_state = {}

function not_terrible_random(low,high)
	if low==high then
		return low
	else
		return math.random(low,high)
	end
end

function shuffle(list)
	for i=1,#list-1 do
		local j = not_terrible_random(i,#list)
		list[i],list[j] = list[j],list[i]
	end
end

function stop_piano()
	global_actors.piano_timer:stoptweening()
	for i=1,26 do
		global_actors.piano_sounds[i]:stoptweening()
	end
end

function play_piano()
	stop_piano()
	
	if quiz_state.are_finished then return end
	
	if piano_state.notes == nil then
		return
	end

	for i,note in ipairs(piano_state.notes) do
		local actor = global_actors.piano_sounds[note+piano_state.root]
		actor:sleep(0.5 + (i-1)*piano_state.note_separation)
		actor:queuecommand('Play')
	end
	
	local delay = #piano_state.notes * piano_state.note_separation + 3
	
	global_actors.piano_timer:sleep(delay)
	global_actors.piano_timer:queuecommand('Trigger')
end

function ask_next_question()
	quiz_state.question_index = quiz_state.question_index + 1
	
	local question_type = math.random(1,#NOTE_QUESTION_DATA)
	local question_data = NOTE_QUESTION_DATA[question_type]
	
	local answers = {}
	local answer_count = 4
	
	for i,answer in ipairs(question_data.pitch_sets) do
		local needed = answer_count - #answers
		local remaining = #question_data.pitch_sets - i + 1
		
		local p = needed / remaining
		
		if math.random() <= p then
			answers[#answers+1] = answer
		end
	end
	
	shuffle(answers)
	quiz_state.answers = answers
	quiz_state.correct_answer_index = math.random(1,answer_count)
	
	for i,answer in ipairs(answers) do
		global_actors.answers[i]:settext(answer.name)
	end
	
	global_actors.question:settext('Identify this ' .. question_data.description)
	
	local correct_answer = answers[quiz_state.correct_answer_index]
	
	local root = math.random(1,12)
	
	piano_state.notes = correct_answer.notes
	piano_state.root = root
	piano_state.note_separation = question_data.note_separation
	play_piano()
	
	global_actors.question_container:linear(0.5)
	global_actors.question_container:diffusealpha(1)
end

on_command = function()
	ask_next_question()
end

input_handler = function(event)
	if quiz_state.are_finished then return end

	if event.type ~= "InputEventType_FirstPress" then return end
	
	local input_player = event.PlayerNumber == "PlayerNumber_P1" and 1 or 2
	
	if quiz_state.is_wrong[input_player] then return end
	
	if quiz_state.correct_answer_index == nil then return end
	
	local answer_index
	if event.button == 'Left' then
		answer_index = 1
	elseif event.button == 'Down' then
		answer_index = 2
	elseif event.button == 'Up' then
		answer_index = 3
	elseif event.button == 'Right' then
		answer_index = 4
	else
		return
	end
	
	if quiz_state.correct_answer_index ~= answer_index then
		quiz_state.is_wrong[input_player] = true
		local wrong_actor = player_actors[input_player].wrong
		wrong_actor:diffusealpha(1)
		wrong_actor:sleep(4.75)
		wrong_actor:linear(0.25)
		wrong_actor:diffusealpha(0)
		wrong_actor:queuecommand('EndWrong')
		
		global_actors.wrong_sound:queuecommand('Play')
	else
		local new_score = quiz_state.scores[input_player] + 1
		quiz_state.scores[input_player] = new_score
		quiz_state.correct_answer_index = nil
		quiz_state.answers = nil
		
		local right_actor = player_actors[input_player].right
		right_actor:diffusealpha(1)
		right_actor:sleep(0.5)
		right_actor:linear(0.25)
		right_actor:diffusealpha(0)
		right_actor:sleep(0.25)
		right_actor:queuecommand('EndRight')
		
		global_actors.question_container:linear(0.5)
		global_actors.question_container:diffusealpha(0)
		
		player_actors[input_player].score:settext('SCORE: '..new_score)
		
		global_actors.right_sound:queuecommand('Play')
		
		stop_piano()
	end
end

piano_timer_listener = function()
	play_piano()
end

wrong_timer_listener = function(player_index)
	quiz_state.is_wrong[player_index] = false
end

right_timer_listener = function(player_index)
	ask_next_question()
end

timeout_listener = function()
	quiz_state.are_finished = true
	stop_piano()
	
	global_actors.container:stoptweening()
	global_actors.container:linear(1)
	global_actors.container:diffusealpha(0)
	
	local losers
	if quiz_state.scores[1] == quiz_state.scores[2] then
		losers = {1,2}
	elseif quiz_state.scores[1] < quiz_state.scores[2] then
		losers = {1}
	else
		losers = {2}
	end
	
	for i,loser in ipairs(losers) do
		if GAMESTATE:IsPlayerEnabled(loser-1) then
			local ps = GAMESTATE:GetPlayerState('PlayerNumber_P' .. loser)
			local po = ps:GetPlayerOptions('ModsLevel_Song')
			po:Flip(1,999999)
		end
	end
	
	
end

return actor_frame